﻿/*	VERSION:	1.1

DESCRIPTION:
	Converts a string into an object
		{myVar:42,var2:merf}  ->  object
	To specify an object, enclose the variable:value pairs in {}
		and separate them with ,
	
	If braces are found, the specified object is returned
	else:		the original string is returned
	If an object is made, text outside of the {} is dropped.
	
	Nested objects are NOT supported.
	Consecutive objects are NOT supported.
*/
#include "getImpliedValue.as"
makeStringObject = function( input_str )
{
	var output = null;
	var objectStart = input_str.indexOf("{");
	if( objectStart == -1 )
	{// if:  not an object
		output = input_str;
	}// if:  not an object
	else
	{// if:  object string
		var newObj = {};
		var objectEnd = input_str.indexOf("}", objectStart+1);
		var object_str = input_str.substring(objectStart+1, objectEnd);
		var object_array = object_str.split(",");
		for(var i=0; i<object_array.length; i++){
			var this_str = object_array[i];
			var splitAt = this_str.indexOf(":");
			var varName = this_str.substr(0,splitAt);
			var value = this_str.substr(splitAt+1);
			value = getImpliedValue( value );
			newObj[varName] = value;
		}//  for:  each variable described
		output = newObj;
	}// if:  object string
	return output;
}// makeStringObject()